extensions [ nw ]
globals [ centralities 
          clustering-coefficient
          centralities-diff
          clustering-coefficient-diff
          ]
turtles-own
[
  source
  belong-to   ;;news belong to whome
  centrality
  local-cluster
  newscolor   ;;initial news color red
  nodecolor   ;;original color
]


breed [news a-news]
breed [people node]

;;red 15, pink 135, blue 105, yellow 45



to setup
  clear-all
  create-people 1 [set color 15 set nodecolor 15 set shape "circle" set size 0.6]
  create-people 1 [set color 15 set nodecolor 15 create-link-with turtle 0 set shape "circle" set size 0.6]
  while [count turtles < number-of-nodes]
  [
  setup-initial-network find-partner
  ]
  ask one-of turtles[set color 135]
  let newscreater turtles with [color = 135]
  nw:set-snapshot turtles links
  cal-centrality newscreater
  setup-news 
  ask news [put-ontop]
  set centralities []
  set clustering-coefficient []
  set centralities-diff []
  set clustering-coefficient-diff []
  ;set centralities fput [centrality] of newscreater centralities
  ;set noderead fput 1 noderead
  reset-ticks
end
  
;;prefential attachment
to setup-initial-network [old-node]
  
  create-people 1
  [
    set color 15
    set nodecolor 15
    set shape "circle"
    set size 0.6
    if old-node != nobody
      [ create-link-with old-node 
        ;; position the new node near its partner
        move-to old-node
        fd 8
      ]
  ]
    
  
end

to-report find-partner
  let total random-float sum [count link-neighbors] of turtles
  let partner nobody
  ask turtles
  [
    let nc count link-neighbors
    ;; if there's no winner yet...
    if partner = nobody
    [
      ifelse nc > total
        [ set partner self ]
        [ set total total - nc ]
    ]
  ]
  report partner
end
;;;;;;;;;;;;;;;;;;;;;;;;;

to setup-news
  create-news 1
  [ 
    set shape "square"
    set color 45  ;;yellow
    set newscolor 15
    set size 1
    set source one-of turtles with [color = 135]
    ]
  let temp one-of turtles with [color = 135]
  ask news [move-to temp set belong-to temp]
   
end
  
to grow
   ifelse ticks mod news-life = 0 and ticks > 0
  [
    let countgreen count people with [color = 65]
    let countpink count people with [color = 135]
    let countgrey count people with [color = 9]
    let countsame countgreen + countpink
    let countdiff countgrey
    let countread countsame + countdiff
    
    ;;set noderead fput countread noderead
  
    ask news [die]
  ask turtles [set color nodecolor]
  ask one-of turtles [set color 135]
  let newscreater turtles with [color = 135]
  setup-news
  cal-centrality newscreater
  ;;set centralities fput [centrality] of newscreater centralities
  ]
  
  [
  ask turtles with [color = 135]
  [
    
    while [count link-neighbors with [color = 15 or color = 105] > 0]
    [
    let spread one-of link-neighbors with [color != 135] ;;node we are going to spread
    let parent one-of turtles-here with [color = 45]  ;;news to be spread
    
    if spread != nobody [
      
      ifelse [newscolor] of parent = [color] of spread
      [
        ask spread [set color 65]      ;; the people with same opinion read the news green
      if random-float 100 < news-is-interesting [
        ask spread [set color 135]
        ask parent[hatch 1]
        ask parent [move-to spread set belong-to spread]
        ask spread [create-link-with [source] of parent]
        ]] 
      [
        ask spread [set color 9]     ;; the people with different opinion read the news grey
        ]
    ]
    ]
    ]
  ]
  
  tick
end

to spreadnews
   ifelse ticks mod news-life = 0 and ticks > 0
  [
    let countgreen count people with [color = 65]
    let countpink count people with [color = 135]
    let countgrey count people with [color = 9]
    let countsame countgreen + countpink
    let countdiff countgrey
    let countread countsame + countdiff   ;;everyone read news
    let creater [source] of one-of news
    ;;set noderead fput countread noderead
    
    set centralities fput(list [centrality] of creater countread) centralities
    set centralities-diff fput(list [centrality] of creater countdiff) centralities-diff
    if [local-cluster] of creater > 0
    [
      set clustering-coefficient fput(list [local-cluster] of creater countread) clustering-coefficient
      set clustering-coefficient-diff fput(list [local-cluster] of creater countdiff) clustering-coefficient-diff
      ]
    ask news [die]
  ask turtles [set color nodecolor]
  ask one-of turtles [set color 135]
  let newscreater turtles with [color = 135]
  setup-news
  cal-centrality newscreater
  cal-cluster newscreater
  ;set centralities fput [centrality] of newscreater centralities
  ]
  
  [
  ask turtles with [color = 135]
  [
    
    while [count link-neighbors with [color = 15 or color = 105] > 0]
    [
    let spread one-of link-neighbors with [color != 135] ;;node we are going to spread
    let parent one-of turtles-here with [color = 45]  ;;news to be spread
    
    if spread != nobody [
      
      ifelse [newscolor] of parent = [color] of spread
      [
        ask spread [set color 65]      ;; the people with same opinion read the news green
      if random-float 100 < news-is-interesting [
        ask spread [set color 135]
        ask parent[hatch 1]
        ask parent [move-to spread set belong-to spread]
        ]] 
      [
        ask spread [set color 9]     ;; the people with different opinion read the news grey
        ]
    ]
    ]
    ]
  ]
  
  tick
  
end


to put-ontop
  hatch 1;;[create-links-with [links]of myself]
  die
end

to layout
  ;; the number 3 here is arbitrary; more repetitions slows down the
  ;; model, but too few gives poor layouts
  repeat 3 [
    ;; the more turtles we have to fit into the same amount of space,
    ;; the smaller the inputs to layout-spring we'll need to use
    let factor sqrt count turtles
    ;; numbers here are arbitrarily chosen for pleasing appearance
    layout-spring turtles links (1 / factor) (7 / factor) (1 / factor)
    display  ;; for smooth animation
  ]
  ;; don't bump the edges of the world
  let x-offset max [xcor] of turtles + min [xcor] of turtles
  let y-offset max [ycor] of turtles + min [ycor] of turtles
  ;; big jumps look funny, so only adjust a little each time
  set x-offset limit-magnitude x-offset 0.1
  set y-offset limit-magnitude y-offset 0.1
  ask turtles [ setxy (xcor - x-offset / 2) (ycor - y-offset / 2) ]
  ask news [move-to [belong-to] of self]
end

to-report limit-magnitude [number limit]
  if number > limit [ report limit ]
  if number < (- limit) [ report (- limit) ]
  report number
end

to resize-nodes
  ifelse all? turtles [size <= 1]
  [
    ;; a node is a circle with diameter determined by
    ;; the SIZE variable; using SQRT makes the circle's
    ;; area proportional to its degree
    ask turtles [ set size sqrt count link-neighbors ]
  ]
  [
    ask turtles [ set size 1 ]
  ]
end

to cal-centrality [choice]
  ifelse centrality-measure = "degree-centrality"
  [ask choice [ 
        set centrality count my-links
      ]
    ]
  [
    ask choice[
  set centrality runresult (word "nw:" centrality-measure)
  ]
  ]
  ;;report [centrality] of choice
end

to cal-cluster [choice]
  ask choice
  [ let hood link-neighbors
    ifelse count hood <= 1
    [
      set local-cluster -1
    ]
    [
      let links-in-hood links with [ (member? end1 hood and member? end2 hood) ]
      set local-cluster (2 * count links-in-hood) / (count hood * (count hood - 1))
    ]
    ]

end

to cal-local-cluster [choice]
  ask choice
  [let num-nei one-of link-neighbors with [color = 15]
    
    ]
end

to two-color
  ask people with [who mod 2 = 0]
  [ 
    if color != 135
    [
    set color 105
    set nodecolor 105
    ]
    ]
  
end
  
@#$#@#$#@
GRAPHICS-WINDOW
438
14
952
536
40
39
6.222222222222222
1
10
1
1
1
0
1
1
1
-40
40
-39
39
1
1
1
ticks
30.0

SLIDER
22
14
162
47
number-of-nodes
number-of-nodes
1
1000
650
1
1
NIL
HORIZONTAL

BUTTON
22
182
85
215
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
21
349
84
382
NIL
grow
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
22
105
162
138
news-is-interesting
news-is-interesting
0
100
50
1
1
%
HORIZONTAL

BUTTON
21
387
114
420
grow-once
grow
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
177
371
431
492
num people read news vs tick
tick
num of people read news
0.0
20.0
0.0
200.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot count turtles with [color = pink or color = 69]"

BUTTON
21
223
116
256
redo layout
layout
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
21
265
123
298
NIL
resize-nodes
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

CHOOSER
22
54
162
99
centrality-measure
centrality-measure
"degree-centrality" "betweenness-centrality" "eigenvector-centrality" "closeness-centrality" "random"
0

PLOT
178
13
429
180
num people read news vs Centrality
Centrality
# People read news
0.0
0.0010
0.0
1.0
true
false
"" ""
PENS
"default" 1.0 2 -16777216 true "" "if length centralities > 0\n[\nplotxy first first centralities last first centralities\n]"

BUTTON
21
308
104
341
NIL
two-color
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
21
426
119
459
NIL
spreadnews
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
21
468
150
501
spreadnews-once
spreadnews
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
178
187
431
356
num people read news vs Local cluster
Local cluster coefficient
# people read news
0.0
1.0
0.0
1.0
true
false
"" ""
PENS
"default" 1.0 2 -16777216 true "" "if length clustering-coefficient > 0\n[\nplotxy first first clustering-coefficient last first clustering-coefficient\n]"

SLIDER
22
143
162
176
news-life
news-life
0
8
3
1
1
NIL
HORIZONTAL

PLOT
963
16
1238
188
num people read with different opinion vs Centrality
Centrality
# people read news 
0.0
0.01
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 2 -16777216 true "" "if length centralities-diff > 0\n[\nplotxy first first centralities-diff last first centralities-diff\n]"

PLOT
963
200
1239
368
num people read with different opinion vs Local cluster
Local cluster coefficient
# people read news
0.0
1.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 2 -16777216 true "" "if length clustering-coefficient-diff > 0\n[\nplotxy first first clustering-coefficient-diff last first clustering-coefficient-diff\n]"

@#$#@#$#@
## WHAT IS IT?

This model is a simulated social network sites. Each node represent a people in On                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    